/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import com.samsarasoftware.license.licenses.ProductLicense;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ThresholdingOutputStream
extends OutputStream {
    private final int threshold;
    private long written;
    private boolean thresholdExceeded;

    public ThresholdingOutputStream(int n) {
        this.threshold = n;
    }

    public void write(int n) throws IOException {
        this.checkThreshold(1);
        this.getStream().write(n);
        ++this.written;
    }

    public void write(byte[] byArray) throws IOException {
        this.checkThreshold(byArray.length);
        this.getStream().write(byArray);
        this.written += (long)byArray.length;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkThreshold(n2);
        this.getStream().write(byArray, n, n2);
        this.written += (long)n2;
    }

    public void flush() throws IOException {
        this.getStream().flush();
    }

    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getStream().close();
    }

    public int getThreshold() {
        return this.threshold;
    }

    public long getByteCount() {
        return this.written;
    }

    public boolean isThresholdExceeded() {
        long l;
        block4: {
            block5: {
                boolean bl = ProductLicense.a;
                long l2 = this.written - (long)this.threshold;
                l = l2 == 0L ? (byte)0 : (l2 < 0L ? (byte)-1 : 1);
                if (bl || bl) break block4;
                if (l <= 0) break block5;
                l = 1;
                break block4;
            }
            l = 0;
        }
        return (boolean)l;
    }

    protected void checkThreshold(int n) throws IOException {
        block13: {
            ThresholdingOutputStream thresholdingOutputStream;
            block14: {
                int n2;
                block12: {
                    boolean bl = ProductLicense.a;
                    n2 = this.thresholdExceeded;
                    if (bl || bl) break block12;
                    if (n2 != 0) break block13;
                    thresholdingOutputStream = this;
                    if (bl) break block14;
                    if (bl) break block14;
                    long l = thresholdingOutputStream.written + (long)n - (long)this.threshold;
                    n2 = l == 0L ? (byte)0 : (l < 0L ? (byte)-1 : 1);
                }
                if (n2 <= 0) break block13;
                this.thresholdExceeded = true;
                thresholdingOutputStream = this;
            }
            thresholdingOutputStream.thresholdReached();
        }
    }

    protected void resetByteCount() {
        this.thresholdExceeded = false;
        this.written = 0L;
    }

    protected abstract OutputStream getStream() throws IOException;

    protected abstract void thresholdReached() throws IOException;
}

